/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.tr7zw.trender.gui.impl.VisualLogger;
import dev.tr7zw.trender.gui.widget.WItemSlot;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class ValidatedSlot
extends class_1735 {
    public static final Predicate<class_1799> DEFAULT_ITEM_FILTER = stack -> true;
    private static final VisualLogger LOGGER = new VisualLogger(ValidatedSlot.class);
    private final int slotNumber;
    private boolean insertingAllowed = true;
    private boolean takingAllowed = true;
    private Predicate<class_1799> inputFilter = DEFAULT_ITEM_FILTER;
    private Predicate<class_1799> outputFilter = DEFAULT_ITEM_FILTER;
    protected final Multimap<WItemSlot, WItemSlot.ChangeListener> listeners = HashMultimap.create();
    private boolean visible = true;

    public ValidatedSlot(class_1263 inventory, int index, int x, int y) {
        super(inventory, index, x, y);
        if (inventory == null) {
            throw new IllegalArgumentException("Can't make an itemslot from a null inventory!");
        }
        this.slotNumber = index;
    }

    public boolean method_7680(class_1799 stack) {
        return this.insertingAllowed && this.field_7871.method_5437(this.slotNumber, stack) && this.inputFilter.test(stack);
    }

    public boolean method_7674(class_1657 player) {
        return this.takingAllowed && this.field_7871.method_5443(player) && this.outputFilter.test(this.method_7677());
    }

    public class_1799 method_7677() {
        if (this.field_7871 == null) {
            LOGGER.warn("Prevented null-inventory from WItemSlot with slot #: {}", this.slotNumber);
            return class_1799.field_8037;
        }
        class_1799 result = super.method_7677();
        if (result == null) {
            LOGGER.warn("Prevented null-itemstack crash from: {}", this.field_7871.getClass().getCanonicalName());
            return class_1799.field_8037;
        }
        return result;
    }

    public void method_7668() {
        this.listeners.forEach((slot, listener) -> listener.onStackChanged((WItemSlot)slot, this.field_7871, this.getInventoryIndex(), this.method_7677()));
        super.method_7668();
    }

    public int getInventoryIndex() {
        return this.slotNumber;
    }

    public boolean isInsertingAllowed() {
        return this.insertingAllowed;
    }

    public void setInsertingAllowed(boolean insertingAllowed) {
        this.insertingAllowed = insertingAllowed;
    }

    public boolean isTakingAllowed() {
        return this.takingAllowed;
    }

    public void setTakingAllowed(boolean takingAllowed) {
        this.takingAllowed = takingAllowed;
    }

    public Predicate<class_1799> getInputFilter() {
        return this.inputFilter;
    }

    public void setInputFilter(Predicate<class_1799> inputFilter) {
        this.inputFilter = inputFilter;
    }

    public Predicate<class_1799> getOutputFilter() {
        return this.outputFilter;
    }

    public void setOutputFilter(Predicate<class_1799> outputFilter) {
        this.outputFilter = outputFilter;
    }

    public void addChangeListener(WItemSlot owner, WItemSlot.ChangeListener listener) {
        Objects.requireNonNull(owner, "owner");
        Objects.requireNonNull(listener, "listener");
        this.listeners.put((Object)owner, (Object)listener);
    }

    public boolean method_7682() {
        return this.isVisible();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

